//
//  Controller.m
//  Greeting
//
//  Created by Fumihiro Tezuka on 10/08/16.
//  Copyright 2010 viva Cocoa. All rights reserved.
//

#import "Controller.h"

@implementation Controller

- (id)init{
	[super init];
	model = [[Model alloc] init];
	voiceArray = [NSSpeechSynthesizer availableVoices];
	return self;
}

- (IBAction)inputString:(id)sender
{
	[model setGreeting:[sender stringValue]];
	NSString *greetingString = [model greeting];
	NSSpeechSynthesizer *synthesizer;
	for (NSString *voiceIdentifier in voiceArray) {
		synthesizer = [[NSSpeechSynthesizer alloc] initWithVoice:voiceIdentifier];
		[synthesizer startSpeakingString:greetingString];
		[outputString setStringValue:voiceIdentifier];
		
		/* テキスト・ビューとスピーチシンセサイザーでユーザーに現在の状態を伝えるための時間を確保 */
		[[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:2.5]];
	}
}

@end
